'''
Created on Aug 21, 2017

@author: Esa Pursiheimo
'''

import sys

from math import *
import os.path
from PySide.QtGui import *
from PySide.QtCore import *
from _collections import defaultdict
from PySide import QtGui
from gis_gui import Ui_Form
from collections import Counter
import pickle

class Gis_app(QWidget,Ui_Form):
    def __init__(self,parent=None,main=None,folder=None):
        super(Gis_app,self).__init__(parent)
        self.setupUi(self)
        self.gis_path = '.\\GIS\\'+folder
        self.main_app = main
        self.gview = Gis_Window(self,folder)
        self.gview.setRenderHint(QPainter.Antialiasing)
        self.scroll.setWidget(self.gview)
        
        
        self.add_cons.clicked.connect(lambda: self.set_point(True))
        self.add_prod.clicked.connect(lambda: self.set_point(False))
        self.add_pipe.clicked.connect(lambda: self.set_lines())
        self.sel_objs.stateChanged.connect(lambda: self.select_objects())
        self.grid_on.stateChanged.connect(lambda: self.grid_change())
        self.hide_map.stateChanged.connect(lambda: self.toggle_map())


        self.add_supply.clicked.connect(lambda: self.open_supply())
        self.del_supply.clicked.connect(lambda: self.delete_supply())
        self.add_stor.clicked.connect(lambda: self.open_storage())
        self.del_stor.clicked.connect(lambda: self.delete_storage())


        # get pipeline details from DH_pipes.txt
        self.pipe_list = []
        with open('Data\\pipedata.txt','r') as fp:
            for i,f in enumerate(fp):
                if i > 0:
                    self.pipe_type.addItem(f.split('\t')[0])
                    self.pipe_list.append(f.split('\t')[0])

        # set warning text font color
        #self.gis_warning.setStyleSheet('color: red')
        
        # create dictionary for model components
        self.archive_dic = defaultdict(dict)
        self.archive_dic['Consumers'] = {}
        self.archive_dic['Producers'] = {}
        self.archive_dic['Supply'] = {}
        self.archive_dic['Storage'] = {}
        self.archive_dic['Pipeline'] = {}
        
        self.archive_dic['Supply']['desc'] = ['Technology',
                                              'Resource',
                                              'Efficiency (el)',
                                              'Efficiency (he)',
                                              'Capacity',
                                              'CAPEX',
                                              'O&M cost'] 
        self.archive_dic['Producers']['desc'] = ['Technology',
                                                 'Capacity',
                                                 'Efficiency (na)',
                                                 'Efficiency (el)',
                                                 'Efficiency (he)',
                                                 'CAPEX',
                                                 'O&M cost']
        self.archive_dic['Storage']['desc'] = ['Technology',
                                               'Capacity',
                                               'Loss factor',
                                               'Load capacity',
                                               'Unload capacity',
                                               'CAPEX']
        self.archive_dic['Consumers']['desc'] = ['Consumer type']
        self.archive_dic['Pipeline']['desc'] = ['Type','Length']
        
        # create dictionary for consumer reference case
        self.reference_con = defaultdict(dict)
        
        # undo object dictionary
        self.undo_dic = None
        
        
        # draw line status (1 = on, 0 = off)
        self.gview.draw_sta = 0
        # add point status
        self.gview.point_sta = 1
        # select objects status
        self.gview.select_sta = 0
        self.node_dic = {}
        
        # pixels to meters transform factor from coordinates and image size
        fig_path = self.gis_path+'\\Map.png'
        coord_path = self.gis_path+'\\Coordinates.txt'
        self.coord_factor = 8.13
        

        # read cooling_techs.txt into producer dictionary
        self.cool_dic = defaultdict(list)
        with open('.\\Data\\cooling_techs.txt','r') as cp:
            for i, c in enumerate(cp):
                vec = c.strip('\n').split('\t')
                if i == 0:
                    dkey = []
                    for j, v in enumerate(vec):
                        if j > 0:
                            dkey.append(v)
                            self.cool_dic[v] = []
                else:
                    for j, v in enumerate(vec):
                        if j > 0:
                            self.cool_dic[dkey[j-1]].append(v)
        # read resorces into dictionary from resources.txt
        self.resource_dic = defaultdict(list)
        with open('.\\Data\\techs_and_resources.txt','r') as rp:
            for r in rp:
                vec = r.strip('\n').split(':')
                self.resource_dic[vec[0]] = vec[1].split(',')

        # read supply_techs.txt into producer dictionary
        self.supply_dic = defaultdict(list)
        with open('.\\Data\\supply_techs.txt','r') as sp:
            tec_tup = []
            for i,s in enumerate(sp):
                vec = s.strip('\n').split('\t')[1:5]
                if i == 0:
                    row1 = vec
                else:
                    for j,v in enumerate(vec):
                        self.supply_dic[row1[j]].append(v)
                      
        #self.cool_tecs = ['Compression chiller','Absoprtion chiller','Free cooling']
        self.cool_slot = [self.pro_cap,self.pro_effn,self.pro_effe,self.pro_effh,self.pro_capex,self.pro_om]
        
        for cn in dkey:
            self.prod_type.addItem(cn)
        self.prod_type.currentIndexChanged.connect(lambda: self.update_prod_details())
        self.update_prod_details()
        self.show()
    
    def open_supply(self):
        self.sup_window = supply_data(parent=None,qwid = self)
        self.sup_window.show()
    
    def open_storage(self):
        self.sto_window = storage_data(parent=None,qwid = self)
        self.sto_window.show()
    
    def delete_supply(self):
        self.sup_del_win = supply_del(parent=None,qwid=self,type='Supply')
        self.sup_del_win.show()
    
    def delete_storage(self):
        self.sto_del_win = supply_del(parent=None,qwid=self,type='Storage')
        self.sto_del_win.show()
    
    def update_prod_details(self):
        ckey = self.prod_type.currentText()
        for i, c in enumerate(self.cool_slot):
            c.setText(self.cool_dic[ckey][i])
    
        
    def select_objects(self):
        if self.sel_objs.isChecked():
            self.gview.select_sta = 1
            for it in self.gview.prod_db:
                it.setFlag(QGraphicsItem.ItemIsSelectable,True)
            for it in self.gview.cons_db:
                it.setFlag(QGraphicsItem.ItemIsSelectable,True)
            for it in self.gview.line_db:
                it.setFlag(QGraphicsItem.ItemIsSelectable,True)            
        else:
            self.gview.select_sta = 0
            for it in self.gview.prod_db:
                it.setFlag(QGraphicsItem.ItemIsSelectable,False)
            for it in self.gview.cons_db:
                it.setFlag(QGraphicsItem.ItemIsSelectable,False)
            for it in self.gview.line_db:
                it.setFlag(QGraphicsItem.ItemIsSelectable,False)   
        
    def set_lines(self):
        self.gview.draw_sta = 1
        self.gview.select_sta = 0
        for it in self.gview.prod_db:
            it.setFlag(QGraphicsItem.ItemIsSelectable,False)
        for it in self.gview.cons_db:
            it.setFlag(QGraphicsItem.ItemIsSelectable,False)
        for it in self.gview.line_db:
            it.setFlag(QGraphicsItem.ItemIsSelectable,False)
        self.sel_objs.setChecked(False)
        self.add_prod.setEnabled(True)
        self.add_cons.setEnabled(True)
        self.add_pipe.setEnabled(False)
        self.add_cons.setStyleSheet("background-color: rgb(240,240,240)")
        self.add_prod.setStyleSheet("background-color: rgb(240,240,240)")
        self.add_pipe.setStyleSheet("background-color: palegreen")
        
    def set_point(self, boo):
        self.gview.draw_sta = 0
        self.gview.line_sta = 0
        self.gview.select_sta = 0
        for it in self.gview.prod_db:
            it.setFlag(QGraphicsItem.ItemIsSelectable,False)
        for it in self.gview.cons_db:
            it.setFlag(QGraphicsItem.ItemIsSelectable,False)
        for it in self.gview.line_db:
            it.setFlag(QGraphicsItem.ItemIsSelectable,False)
        self.sel_objs.setChecked(False)
        if boo:
            self.gview.point_sta = 1
            self.add_cons.setEnabled(False)
            self.add_prod.setEnabled(True)
            self.add_pipe.setEnabled(True)
            self.add_cons.setStyleSheet("background-color: palegreen")
            self.add_prod.setStyleSheet("background-color: rgb(240,240,240)")
            self.add_pipe.setStyleSheet("background-color: rgb(240,240,240)")
        else:
            self.gview.point_sta = 0
            self.add_cons.setEnabled(True)
            self.add_prod.setEnabled(False)
            self.add_pipe.setEnabled(True)
            self.add_cons.setStyleSheet("background-color: rgb(240,240,240)")
            self.add_prod.setStyleSheet("background-color: palegreen")
            self.add_pipe.setStyleSheet("background-color: rgb(240,240,240)")
       
    def grid_change(self):
        if self.grid_on.isChecked():
            for item in self.gview.g_db:
                item.setVisible(True)
        else:
            for item in self.gview.g_db:
                item.setVisible(False)

    def toggle_map(self):
        if self.hide_map.isChecked():
            #self.gview.map_fig.setVisible(False)
            self.gview.map_fig.setOpacity(0.3)
        else:
            #self.gview.map_fig.setVisible(True)
            self.gview.map_fig.setOpacity(1.0)
        

    # checks nodes and exports node data to text files    
    def export_nodes(self,casename):
        pd = self.gview.prod_db
        cd = self.gview.cons_db
        ld = self.gview.line_db
        rd = self.reference_con
        node_list = []
        
        # get coordinates from point (consumers+producers) and line (pipeline) dictionaries to list node_list
        for c in cd:
            node_list.append(cd[c][1])
        for p in pd:
            node_list.append(pd[p][1])
        for k in ld:
            node_list.append(ld[k][2])
            node_list.append(ld[k][3])
        
        # get number of identical coordinates and examine minimum of these numbers
        # if single coordinate is found, network structure is incomplete, give warning and exit function
        min_nod = min(dict(Counter(node_list)).values())    
        if min_nod == 1:
            return -1
        
        # get list of unique coordinates
        no_c = list(set(node_list))
        
        
        nindx = 1
        for n in no_c:
            self.node_dic['NOD'+str(nindx)]=n
            #self.gview.scene.addEllipse(n[0]-8,n[1]-8,16,16,QPen(Qt.red,3))
            nindx += 1
        un_node_dic = {v: k for k, v in self.node_dic.items()}
        
        with open(self.gis_path+'\\dh_network_'+casename+'.txt','w') as f:
            for l in ld:
                f.write(ld[l][0]+'\t'+un_node_dic[ld[l][2]]+'\t'+un_node_dic[ld[l][3]]+'\n')

        '''
        with open(self.gis_path+'\\dh_con.txt','w') as f:
            for c in cd:
                f.write(cd[c][0]+'\t'+un_node_dic[cd[c][1]]+'\t'+cd[c][2]+'\n')
        '''     
        with open(self.gis_path+'\\prod_con_'+casename+'.txt','w') as f:
            for p in pd:
                f.write(pd[p][0]+'\t'+un_node_dic[pd[p][1]]+'\n')
            for c in cd:
                f.write(cd[c][0]+'\t'+un_node_dic[cd[c][1]]+'\n')            
        
        with open(self.gis_path+'\\dh_nodes_'+casename+'.txt','w') as f:
            for n in sorted(self.node_dic.keys()):
                f.write(n+'\t'+str(self.node_dic[n])+'\n') 
        with open(self.gis_path+'\\system_data_'+casename+'.txt','w') as f:
            for k in sorted(self.archive_dic.keys()):
                f.write(k+':\n')
                for c in sorted(self.archive_dic[k].keys()):
                    if c != 'desc':
                        f.write(c)
                        for d in self.archive_dic[k][c]:
                            f.write('\t'+d)
                        f.write('\n')
           
        # get producer tec options                
        tecs = sorted(self.cool_dic.keys())   
        heat_tecs = ['Boiler','CHP']
        fuel_vec = self.resource_dic['CHP'] 
        with open(self.gis_path+'\\reference_data_'+casename+'.txt','w') as f:
            for c in sorted(rd.keys()):
                # building identifier line
                dat_c = c+'\t'+rd[c][0]
                f.write(dat_c+'\n')
                # producer tec
                tec = tecs[int(rd[c][1])]
                par_vec = self.cool_dic[tec][:-3]
                par_vec[0] = str(rd[c][2])
                dat_p = 'P1'+'\t'+tec
                for v in par_vec:
                    dat_p = dat_p+'\t'+v
                f.write(dat_p+'\n')
                if rd[c][1] == 0:
                    dat_s = 'S1'+'\t'+heat_tecs[int(rd[c][3])]+'\t'+fuel_vec[int(rd[c][4])]
                    par_vec = self.supply_dic[heat_tecs[int(rd[c][3])]][:-3]
                    par_vec[2] = str(rd[c][5])
                    for v in par_vec:
                        dat_s = dat_s+'\t'+v
                    f.write(dat_s+'\n')
                    if rd[c][6] == 1:
                        dat_s = 'S2\tCollectors\tSun'
                        par_vec = self.supply_dic['Collectors'][:-3]
                        par_vec[2] = str(rd[c][7])
                        for v in par_vec:
                            dat_s = dat_s+'\t'+v
                        f.write(dat_s+'\n')
                if rd[c][6] == 2:
                    dat_s = 'S2\tPVs\tSun'
                    par_vec = self.supply_dic['PVs'][:-3]
                    par_vec[2] = str(rd[c][7])
                    for v in par_vec:
                        dat_s = dat_s+'\t'+v
                    f.write(dat_s+'\n')
                f.write('###\n')
        return 1    
                
class Gis_Window(QGraphicsView):
    def __init__(self,parent,folder):
        super(Gis_Window,self).__init__(parent)
        
        # path definitions
        self.path = '.\\GIS\\'+folder+'\\'
        self.fig_path = '.\\GIS\\'+folder+'\\Map.png'
        
        self.gis_wid = self.parent()
        
        # create and set scene to graphicsview
        self.scene = graph_scene(self) 
        self.setScene(self.scene)
        
        # load png-file and add it into graphics scene
        self.pmap = QPixmap(self.fig_path)
        self.map_fig = self.scene.addPixmap(self.pmap)
        
        rec = self.scene.sceneRect()
        w = rec.width()
        h = rec.height()
        self.setFixedWidth(w+5)
        self.setFixedHeight(h+5)

        # initialise
        self.cons_db = defaultdict(list)
        self.c_indx = 0
        self.prod_db = defaultdict(list)
        self.p_indx = 0
        self.line_db = defaultdict(list)
        self.l_indx = 0
        self.s_indx = 0
        self.t_indx = 0
        
        self.line_sta = 0
        self.st_x = 0
        self.st_y = 0
        
        self.scene_w = self.scene.width()
        self.scene_h = self.scene.height()
        
        
        self.pipe_len = 0
        
        # Create grid
        self.g_db = []
        self.grid_sta = 0
        self.gscale = 10
        #gr_pen = QPen(Qt.red,0)
        gr_pen = QPen(Qt.gray)
        gr_pen.setWidth(0)
        #gr_pen.setDashPattern([5,1])
        for i in range(int(self.scene_w/self.gscale)+1):
            it = self.scene.addLine(i*self.gscale,0,i*self.gscale,self.scene_h,gr_pen)
            it.setVisible(False)
            self.g_db.append(it)
        for j in range(int(self.scene_h/self.gscale)+1):
            jt = self.scene.addLine(0,j*self.gscale,self.scene_w,j*self.gscale,gr_pen)
            jt.setVisible(False)
            self.g_db.append(jt)
        self.show()
    
    # Loads data structures from pickle files:
    def load_struct(self):
        cpic = self.path+'cons.pickle'
        ppic = self.path+'prod.pickle'
        lpic = self.path+'lines.pickle'
        apic = self.path+'arc.pickle'
        fpic = self.path+'ref.pickle'

        c_dic = {}
        p_dic = {}
        l_dic = {}
        if os.path.exists(cpic):
            with open(cpic, 'rb') as handle:
                c_dic = pickle.load(handle)
        if os.path.exists(ppic):
            with open(ppic, 'rb') as handle:
                p_dic = pickle.load(handle)
        if os.path.exists(lpic):
            with open(lpic, 'rb') as handle:
                l_dic = pickle.load(handle)
        if os.path.exists(apic):
            with open(apic, 'rb') as handle:
                self.gis_wid.archive_dic = pickle.load(handle)
        if os.path.exists(fpic):
            with open(fpic, 'rb') as handle:
                self.gis_wid.reference_con = pickle.load(handle)
                        
        s_ind = 0
        t_ind = 0
        for k in self.gis_wid.archive_dic['Supply']:
            if k != 'desc':
                k_num = int(k[1:])
                if k_num >= s_ind:
                    s_ind = k_num+1 
        for t in self.gis_wid.archive_dic['Storage']:
            if t != 'desc':
                k_num = int(t[1:])
                if k_num >= t_ind:
                    t_ind = k_num+1

        self.s_indx = s_ind  
        self.t_indx = t_ind
                   
        pen1 = QPen(Qt.red,2)
        pen2 = QPen(Qt.magenta,2)
        pen3 = QPen(Qt.blue,3)
        
        self.c_indx = 0
        for c in c_dic:
            x = c_dic[c][1][0]
            y = c_dic[c][1][1]
            pid = c_dic[c][0]
            idn = int(pid[1:])
            if idn > self.c_indx:
                self.c_indx = idn
            typ = c_dic[c][2]
            item = self.scene.addEllipse(x-5,y-5,10,10,pen1)
            item.setBrush(QColor("white"))
            item.setToolTip(pid)
            self.cons_db[item] = [pid,(x,y),typ]
            #self.gis_wid.reference_con[pid] = [typ,1,0,0,0,0,0,0]

        self.p_indx = 0
        for p in p_dic:
            x = p_dic[p][1][0]
            y = p_dic[p][1][1]
            pid = p_dic[p][0]
            idn = int(pid[1:])
            if idn > self.p_indx:
                self.p_indx = idn
            item = self.scene.addRect(x-5,y-5,10,10,pen2)
            item.setBrush(QColor("white"))
            item.setToolTip(pid)
            self.prod_db[item] = [pid,(x,y)]
            
        self.l_indx = 0    
        for l in l_dic:
            x1 = l_dic[l][2][0]
            y1 = l_dic[l][2][1]
            x2 = l_dic[l][3][0]
            y2 = l_dic[l][3][1]
            leng = l_dic[l][1]
            typ = l_dic[l][4]
            lid = l_dic[l][0]
            idn = int(lid[1:])
            if idn > self.l_indx:
                self.l_indx = idn            
            item = self.scene.addLine(x1,y1,x2,y2,pen3)
            item.setToolTip(lid+' ('+typ+')')
            self.line_db[item] = [lid,leng,(x1,y1),(x2,y2),typ]                                                                                                        
         

class graph_scene(QGraphicsScene):
    
    def __init__(self,parent):
        super(graph_scene,self).__init__(parent)
        self.gscale = 10
        self.par_wid = self.parent()
        self.org_wid = self.par_wid.parent()
        self.max_y = 0
        self.max_x = 0
        self.c_vec = []
        self.check_items = []
        if os.path.exists(self.org_wid.gis_path+'\\Coordinates.txt'):
            with open(self.org_wid.gis_path+'\\Coordinates.txt','r') as fp:
                for f in fp:
                    self.c_vec.append(float(f.strip('\n').split(' ')[1]))
        else:
            return 0
        
    def  mouseDoubleClickEvent(self, event):
        if self.par_wid.select_sta == 1:
            items = self.selectedItems()
            if len(items) == 1:
                it = items[0]
                if it in list(self.par_wid.line_db.keys()):
                    lid = self.par_wid.line_db[it][0]
                    pipe_typ,ok = QInputDialog.getItem(self.org_wid,'Edit','Select element type for: '+lid,self.org_wid.pipe_list)
                    if ok:
                        
                        self.par_wid.line_db[it][4] = pipe_typ
                        self.org_wid.archive_dic['Pipeline'][lid][0] = pipe_typ
                        it.setToolTip(lid+' ('+pipe_typ+')')
                    else:
                        return 0
                elif it in list(self.par_wid.cons_db.keys()):
                    cid = self.par_wid.cons_db[it][0]
                    con_list = [self.org_wid.con_type.itemText(i) for i in range(self.org_wid.con_type.count())]
                    cons_typ,ok = QInputDialog.getItem(self.org_wid,'Edit','Select consumer type for: '+cid,con_list)
                    if ok:
                        self.org_wid.archive_dic['Consumers'][cid][0] = cons_typ
                        self.par_wid.cons_db[it][2] = cons_typ
                    else:
                        return 0
                        
            else:
                return 0
            
        
        
    def mousePressEvent(self, event):
        self.max_y = round((self.height()-self.gscale)/self.gscale)*self.gscale
        self.max_x = round((self.width()-self.gscale)/self.gscale)*self.gscale
        if self.par_wid.select_sta == 0: 
            if self.par_wid.draw_sta == 0:    
                if event.button() == Qt.LeftButton:

                    x = event.scenePos().x()
                    y = event.scenePos().y()

                    x,y = self.snap_coord(x,y,self.gscale,self.max_x,self.max_y)
                    
                    if self.par_wid.point_sta == 1:
                        if self.org_wid.con_type.count() > 0:
                            self.par_wid.c_indx += 1
                            pen = QPen(Qt.red,2)
                            item = self.addEllipse(x-5,y-5,10,10,pen)
                            item.setBrush(QColor("white"))
                            code = "C"+str(self.par_wid.c_indx)
                            item.setToolTip(code)
                            ctype = self.org_wid.con_type.currentText()
                            self.par_wid.cons_db[item] = [code,(x,y),ctype]
                            self.org_wid.archive_dic['Consumers'][code] = [ctype]
                            self.org_wid.reference_con[code] = [ctype,1,0,0,0,0,0,0]
                            self.org_wid.main_app.statusbar.showMessage('Added consumer '+code+': type '+ctype,2000)
                            self.org_wid.undo_dic = item
                        else:
                            msgBox = QMessageBox()
                            msgBox.setText("No consumer type available - import consumer data file")
                            msgBox.exec_()
                            return 0
                        
                    else:
                        self.par_wid.p_indx += 1
                        pen = QPen(Qt.magenta,2)
                        item = self.addRect(x-5,y-5,10,10,pen)
                        item.setBrush(QColor("white"))
                        code = "P"+str(self.par_wid.p_indx) 
                        item.setToolTip(code)
                        self.par_wid.prod_db[item] = [code,(x,y)]
                        datavec = []
                        datavec.append(self.org_wid.prod_type.currentText())
                        for s in self.org_wid.cool_slot:
                            datavec.append(s.text())
                        self.org_wid.archive_dic['Producers'][code] = datavec
                        self.org_wid.main_app.statusbar.showMessage('Added producer '+code+': type '+datavec[0],2000)
                        self.org_wid.undo_dic = item

            else:
                pen = QPen(Qt.blue,3)
                if event.button() == Qt.LeftButton:
                    if self.par_wid.line_sta == 0:
                        x,y = self.snap_coord(event.scenePos().x(), event.scenePos().y(), self.gscale,self.max_x,self.max_y)             
                        self.st_x = x
                        self.st_y = y
                        self.par_wid.line_sta = 1
                        self.pipe_len = 0
                    else:
                        x,y = self.snap_coord(event.scenePos().x(), event.scenePos().y(), self.gscale,self.max_x,self.max_y) 
                        end_x = x
                        end_y = y
                        if end_x-self.st_x != 0 or end_y-self.st_y != 0:
                            item = self.addLine(self.st_x,self.st_y,end_x,end_y,pen)
                            self.par_wid.l_indx += 1
                            pipe_t = self.org_wid.pipe_type.currentText()
                            code = 'L'+str(self.par_wid.l_indx)
                            item.setToolTip(code+' ('+pipe_t+')')
                            len_pipe = self.calculate_length(self.st_x, self.st_y, end_x, end_y)
                            
                            if len_pipe == 0:
                                self.pipe_len = round(self.org_wid.coord_factor*((end_x-self.st_x)**2+(end_y-self.st_y)**2)**0.5,2)
                            else:
                                self.pipe_len = round(len_pipe,2)
                            self.org_wid.main_app.statusbar.showMessage('Added pipeline '+code+': '+pipe_t+' - '+str(self.pipe_len)+'m',2000)
                            self.par_wid.line_db[item] = [code,self.pipe_len,(self.st_x,self.st_y),(end_x,end_y),pipe_t]
                            self.org_wid.archive_dic['Pipeline'][code] = [pipe_t,str(self.pipe_len)]
                            self.org_wid.undo_dic = item
                            self.st_x = end_x
                            self.st_y = end_y
                if event.button() == Qt.RightButton:
                        if self.par_wid.line_sta == 1:
                            self.par_wid.line_sta = 0
        QGraphicsScene.mousePressEvent(self, event)

    def keyReleaseEvent(self, event):
        key = event.key()
        if key == Qt.Key_Space and not event.isAutoRepeat():
            for c in self.check_items:
                self.removeItem(c)
            del self.check_items[:]
             
             
                                          
    def keyPressEvent(self, event):
        self.max_y = round((self.height()-self.gscale)/self.gscale)*self.gscale
        self.max_x = round((self.width()-self.gscale)/self.gscale)*self.gscale
        key = event.key()
        
        if key == Qt.Key_Z:
            modifiers = QApplication.keyboardModifiers()
            if modifiers == Qt.ControlModifier:
                if bool(self.org_wid.undo_dic):
                    it = self.org_wid.undo_dic
                    self.removeItem(it)
                    if it in self.par_wid.cons_db:
                        code = self.par_wid.cons_db[it][0]
                        del self.par_wid.cons_db[it]
                        del self.org_wid.archive_dic['Consumers'][code]
                        del self.org_wid.reference_con[code]
                        self.org_wid.main_app.statusbar.showMessage('Undo consumer '+code,2000)
                    if it in self.par_wid.prod_db:
                        code = self.par_wid.prod_db[it][0]
                        del self.par_wid.prod_db[it]
                        del self.org_wid.archive_dic['Producers'][code]
                        self.org_wid.main_app.statusbar.showMessage('Undo producer '+code,2000)
                    if it in self.par_wid.line_db:
                        code = self.par_wid.line_db[it][0]
                        del self.par_wid.line_db[it]
                        del self.org_wid.archive_dic['Pipeline'][code]
                        self.org_wid.main_app.statusbar.showMessage('Undo pipe '+code,2000)
                    self.org_wid.undo_dic = None
        
        if key == Qt.Key_W:
            #self.org_wid.archive_dic['Storage']['desc'].append('CAPEX')
            print('Lines:')
            for it in list(self.par_wid.line_db.keys()):
                print(it, self.par_wid.line_db[it])
            print('Cons:')
            for it in list(self.par_wid.cons_db.keys()):
                print(it, self.par_wid.cons_db[it])
            print('Prod:')
            for it in list(self.par_wid.prod_db.keys()):
                print(it, self.par_wid.prod_db[it])
        
        if key == Qt.Key_Q:
            for k in self.org_wid.archive_dic:
                print(k)
                for j in self.org_wid.archive_dic[k]:
                    print(j,self.org_wid.archive_dic[k][j])
           
        if key == Qt.Key_M:
            if self.org_wid.hide_map.isChecked():
            #self.gview.map_fig.setVisible(False)
                self.par_wid.map_fig.setOpacity(0.3)
                self.org_wid.hide_map.setChecked(False)
            else:
            #self.gview.map_fig.setVisible(True)
                self.par_wid.map_fig.setOpacity(1.0)
                self.org_wid.hide_map.setChecked(True)
           
            
        if key == Qt.Key_Space and not event.isAutoRepeat():
            pd = self.par_wid.prod_db
            cd = self.par_wid.cons_db
            ld = self.par_wid.line_db
            node_list = []    
            # get coordinates from point (consumers+producers) and line (pipeline) dictionaries to list node_list
            for c in cd:
                node_list.append(cd[c][1])
            for p in pd:
                node_list.append(pd[p][1])
            for k in ld:
                node_list.append(ld[k][2])
                node_list.append(ld[k][3])
            # get number of identical coordinates and examine minimum of these numbers
            min_nod = dict(Counter(node_list))   
            for m in min_nod:
                x = m[0]
                y = m[1]
                if min_nod[m] > 1:
                    pen = QPen(Qt.darkGreen,2)
                    brush = QBrush(Qt.NoBrush)
                else:
                    pen = QPen(Qt.darkCyan,2)
                    brush = QBrush(Qt.cyan)
                e_size = 16
                item = self.addEllipse(x-e_size/2,y-e_size/2,e_size,e_size,pen,brush)
                self.check_items.append(item)
                

            
            
        if key == Qt.Key_Right:
            if self.par_wid.select_sta == 1:
                for it in self.selectedItems():
                    if it in self.par_wid.cons_db:
                        xpos,ypos = self.par_wid.cons_db[it][1]
                        if xpos+self.gscale<self.max_x:
                            itx = it.pos().x()
                            ity = it.pos().y()
                            npos = (xpos+self.gscale,ypos)
                            it.setPos(itx+self.gscale,ity)
                            self.par_wid.cons_db[it][1] = npos
                    if it in self.par_wid.prod_db:
                        xpos,ypos = self.par_wid.prod_db[it][1]
                        if xpos+self.gscale<self.max_x:
                            itx = it.pos().x()
                            ity = it.pos().y()
                            npos = (xpos+self.gscale,ypos)
                            it.setPos(itx+self.gscale,ity)
                            self.par_wid.prod_db[it][1] = npos                         
        if key == Qt.Key_Left:
            if self.par_wid.select_sta == 1:
                for it in self.selectedItems():
                    if it in self.par_wid.cons_db:
                        xpos,ypos = self.par_wid.cons_db[it][1]
                        if xpos-self.gscale>0:
                            itx = it.pos().x()
                            ity = it.pos().y()
                            npos = (xpos-self.gscale,ypos)
                            it.setPos(itx-self.gscale,ity)
                            self.par_wid.cons_db[it][1] = npos
                    if it in self.par_wid.prod_db:
                        xpos,ypos = self.par_wid.prod_db[it][1]
                        if xpos-self.gscale>0:
                            itx = it.pos().x()
                            ity = it.pos().y()
                            npos = (xpos-self.gscale,ypos)
                            it.setPos(itx-self.gscale,ity)
                            self.par_wid.prod_db[it][1] = npos
        if key == Qt.Key_Up:
            if self.par_wid.select_sta == 1:
                for it in self.selectedItems():
                    if it in self.par_wid.cons_db:
                        xpos,ypos = self.par_wid.cons_db[it][1]
                        if ypos-self.gscale>0:
                            itx = it.pos().x()
                            ity = it.pos().y()
                            npos = (xpos,ypos-self.gscale)
                            it.setPos(itx,ity-self.gscale)
                            self.par_wid.cons_db[it][1] = npos
                    if it in self.par_wid.prod_db:
                        xpos,ypos = self.par_wid.prod_db[it][1]
                        if ypos-self.gscale>0:
                            itx = it.pos().x()
                            ity = it.pos().y()
                            npos = (xpos,ypos-self.gscale)
                            it.setPos(itx,ity-self.gscale)
                            self.par_wid.prod_db[it][1] = npos
        if key == Qt.Key_Down:
            if self.par_wid.select_sta == 1:
                for it in self.selectedItems():
                    if it in self.par_wid.cons_db:
                        xpos,ypos = self.par_wid.cons_db[it][1]
                        if ypos+self.gscale<self.max_y:
                            itx = it.pos().x()
                            ity = it.pos().y()
                            npos = (xpos,ypos+self.gscale)
                            it.setPos(itx,ity+self.gscale)
                            self.par_wid.cons_db[it][1] = npos
                    if it in self.par_wid.prod_db:
                        xpos,ypos = self.par_wid.prod_db[it][1]
                        if ypos+self.gscale<self.max_y:
                            itx = it.pos().x()
                            ity = it.pos().y()
                            npos = (xpos,ypos+self.gscale)
                            it.setPos(itx,ity+self.gscale)
                            self.par_wid.prod_db[it][1] = npos
        if key == Qt.Key_Delete:
            if self.par_wid.select_sta == 1:
                for it in self.selectedItems():
                    self.removeItem(it)
                    if it in self.par_wid.cons_db:
                        code = self.par_wid.cons_db[it][0]
                        del self.par_wid.cons_db[it]
                        del self.org_wid.archive_dic['Consumers'][code]
                        del self.org_wid.reference_con[code]
                    if it in self.par_wid.prod_db:
                        code = self.par_wid.prod_db[it][0]
                        del self.par_wid.prod_db[it]
                        del self.org_wid.archive_dic['Producers'][code]
                    if it in self.par_wid.line_db:
                        code = self.par_wid.line_db[it][0]
                        del self.par_wid.line_db[it]
                        del self.org_wid.archive_dic['Pipeline'][code]
        if key == Qt.Key_A:
            if self.par_wid.select_sta == 1:
                modifiers = QApplication.keyboardModifiers()
                if modifiers == Qt.ControlModifier:
                    items = list(self.par_wid.cons_db.keys())+list(self.par_wid.prod_db.keys())+list(self.par_wid.line_db.keys())
                    for it in items:
                        it.setSelected(True)
                
    def snap_coord(self,x,y,t,m_x,m_y):
        x0 = min(m_x,max(t,round(x/t)*t))
        y0 = min(m_y,max(t,round(y/t)*t))
        return x0,y0
    
    def calculate_length(self,s_x,s_y,e_x,e_y):
        w = self.sceneRect().width()
        h = self.sceneRect().height()
        c_vec = self.c_vec
        lat_s = radians(((h-s_y)/h)*c_vec[0]+((s_y)/h)*c_vec[2])
        lon_s = radians(((w-s_x)/w)*c_vec[1]+((s_x)/w)*c_vec[3])
        lat_e = radians(((h-e_y)/h)*c_vec[0]+((e_y)/h)*c_vec[2])
        lon_e = radians(((w-e_x)/w)*c_vec[1]+((e_x)/w)*c_vec[3])
        (lon_s,lon_e,lat_s,lat_e)
        dist_km = 6371.01 * acos(sin(lat_s)*sin(lat_e) + cos(lat_s)*cos(lat_e)*cos(lon_s - lon_e))
        return 1000*dist_km
        

class supply_data(QWidget):
    def __init__(self,parent=None,qwid=None):
        super(supply_data,self).__init__(parent) 
        self.setWindowTitle('Insert supply data')
        self.main_widget = qwid

        self.vb1 = QVBoxLayout()
        self.vb2 = QVBoxLayout()
        self.vb3 = QVBoxLayout()
        self.hb1 = QHBoxLayout()
        self.hb2 = QHBoxLayout()
        self.ok_b = QPushButton('OK')
        self.ca_b = QPushButton('Cancel')
        self.ok_b.setFont(QtGui.QFont('SansSerif',11))
        self.ca_b.setFont(QtGui.QFont('SansSerif',11))
        
        self.tecs = []
        self.resources = defaultdict(list)
        with open('.\\Data\\techs_and_resources.txt','r') as fp:
            for f in fp:
                vec = (f.strip('\n').split(':'))
                self.tecs.append(vec[0])  
                self.resources[vec[0]] = vec[1].split(',')
        
        self.tec_combo = QComboBox()
        for i in self.tecs:
            self.tec_combo.addItem(i)
        self.res_combo = QComboBox()
        self.tec_combo.setFont(QtGui.QFont('SansSerif',11))
        self.res_combo.setFont(QtGui.QFont('SansSerif',11))
        
        self.vb1.addWidget(self.tec_combo)
        self.vb1.addWidget(self.res_combo)
        self.hb1.addWidget(self.ok_b)
        self.hb1.addWidget(self.ca_b)

        self.sup_label = ['Efficiency (el)',
                          'Efficiency (he)',
                          'Capacity',
                          'CAPEX',
                          'O&M cost']    
        for l in self.sup_label:
            lab = QLabel(l)
            lab.setFont(QtGui.QFont('SansSerif',11))
            self.vb2.addWidget(lab)
        
        self.sup_edit = []
        for i in range(5):
            self.sup_edit.append(QLineEdit())
            self.sup_edit[i].setFont(QtGui.QFont('SansSerif',11))
            self.vb3.addWidget(self.sup_edit[i])
        
        self.hb2.addLayout(self.vb2)
        self.hb2.addLayout(self.vb3)
         
        self.vb1.addLayout(self.hb2)   
        self.vb1.addLayout(self.hb1)
        self.setLayout(self.vb1)      
        
        self.update_resource()
        self.ok_b.clicked.connect(lambda: self.update_supply())
        self.ca_b.clicked.connect(lambda: self.cancel_window())
        self.tec_combo.currentIndexChanged.connect(lambda: self.update_resource())
    
    def update_resource(self):
        self.res_combo.clear()
        ind = self.tec_combo.currentText()
        vec = self.resources[ind]
        for v in vec:
            self.res_combo.addItem(v)
        
    def update_supply(self):
        self.main_widget.gview.s_indx += 1
        code = 'S'+str(self.main_widget.gview.s_indx)
        val = [self.tec_combo.currentText(),self.res_combo.currentText()]
        for i, l in enumerate(self.sup_edit):
            val.append(l.text())
        self.main_widget.archive_dic['Supply'][code] = val
        
        self.close()
        
    def cancel_window(self):
        self.close()

class storage_data(QWidget):
    def __init__(self,parent=None,qwid=None):
        super(storage_data,self).__init__(parent) 
        self.setWindowTitle('Insert storage data')
        self.main_widget = qwid    
        
        self.vb1 = QVBoxLayout()
        self.vb2 = QVBoxLayout()
        self.vb3 = QVBoxLayout()
        self.hb1 = QHBoxLayout()
        self.hb2 = QHBoxLayout()
        self.ok_b = QPushButton('OK')
        self.ca_b = QPushButton('Cancel')
        self.ok_b.setFont(QtGui.QFont('SansSerif',11))
        self.ca_b.setFont(QtGui.QFont('SansSerif',11))
        
        self.tecs = []
        with open('.\\Data\\storages.txt','r') as fp:
            for f in fp:
                self.tecs.append(f.strip('\n'))  
        self.tec_combo = QComboBox()
        self.tec_combo.setFont(QtGui.QFont('SansSerif',11))
        for t in self.tecs:
            self.tec_combo.addItem(t)
        
        self.sup_label = ['Capacity',
                          'Loss factor',
                          'Load capacity',
                          'Unload capacity',
                          'CAPEX']    
        for l in self.sup_label:
            lab = QLabel(l)
            lab.setFont(QtGui.QFont('SansSerif',11))
            self.vb2.addWidget(lab)
        
        self.sup_edit = []
        for i in range(len(self.sup_label)):
            self.sup_edit.append(QLineEdit())
            self.sup_edit[i].setFont(QtGui.QFont('SansSerif',11))
            self.vb3.addWidget(self.sup_edit[i])        
        

        self.vb1.addWidget(self.tec_combo)
        self.hb2.addLayout(self.vb2)
        self.hb2.addLayout(self.vb3)
        self.hb1.addWidget(self.ok_b)
        self.hb1.addWidget(self.ca_b)
        self.vb1.addLayout(self.hb2)   
        self.vb1.addLayout(self.hb1)
        self.setLayout(self.vb1)      
        
        self.ok_b.clicked.connect(lambda: self.update_storage())
        self.ca_b.clicked.connect(lambda: self.cancel_window())      
        
    def update_storage(self):
        self.main_widget.gview.t_indx += 1
        code = 'T'+str(self.main_widget.gview.t_indx)
        val = [self.tec_combo.currentText()]
        for i, l in enumerate(self.sup_edit):
            val.append(l.text())
        self.main_widget.archive_dic['Storage'][code] = val
        self.close()
        
    def cancel_window(self):
        self.close()        
        
        

class supply_del(QWidget):
    def __init__(self,parent=None,qwid=None,type=None):
        super(supply_del,self).__init__(parent) 
        
        self.typ = type
        self.setWindowTitle('Delete '+self.typ+' unit')
        self.main_widget = qwid
        
        vb = QVBoxLayout()
        hb = QHBoxLayout()
        self.ok_b = QPushButton('Ok')
        self.ca_b = QPushButton('Cancel')
        self.ok_b.setFont(QtGui.QFont('SansSerif',11))
        self.ca_b.setFont(QtGui.QFont('SansSerif',11))
        self.ok_b.clicked.connect(lambda: self.press_ok())
        self.ca_b.clicked.connect(lambda: self.press_cancel())
        
        self.sup_list = QListWidget()
        self.sup_list.setFont(QtGui.QFont('Courier',10))
        s_list = []
        for d in self.main_widget.archive_dic[self.typ]:
            if d != 'desc':
                vec = self.main_widget.archive_dic[self.typ][d]
                self.sup_list.addItem(d+': '+'-'.join(vec))
        self.sup_list.sortItems()
        vb.addWidget(self.sup_list)
        hb.addWidget(self.ok_b)
        hb.addWidget(self.ca_b)
        vb.addLayout(hb)
        self.setLayout(vb)
        
    def press_ok(self):
        del_key = self.sup_list.currentItem().text().split(':')[0]
        del self.main_widget.archive_dic[self.typ][del_key]
        self.close()
        
    def press_cancel(self):
        self.close()
        

            

